CREATE OR REPLACE FUNCTION sim2_activity_projects(p_tsrfdact_is_number IN NUMBER,
                                                  p_tsrfdact_org_id    IN VARCHAR2) RETURN VARCHAR2 IS 
  v_proj VARCHAR2(2000);

  CURSOR proj_cur(p_tsrfdact_is_number IN NUMBER,
                  p_tsrfdact_org_id    IN CHAR) IS
    SELECT p.identification_cd
    FROM   tsmproj  p,
           tsrfapra a
    WHERE  p.tsmproj_is_number  = a.tsmproj_is_number
    AND    p.tsmproj_org_id     = a.tsmproj_org_id
    AND    a.tsrfdact_is_number = p_tsrfdact_is_number
    AND    a.tsrfdact_org_id    = p_tsrfdact_org_id;

BEGIN NULL;
  FOR proj_rec IN proj_cur(p_tsrfdact_is_number, p_tsrfdact_org_id) LOOP
    IF v_proj IS NULL THEN
      v_proj := proj_rec.identification_cd;
    ELSE
      v_proj := v_proj||'\'||proj_rec.identification_cd;
    END IF;
  END LOOP;
  
  RETURN v_proj;
END sim2_activity_projects;
/

